
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   UTC_SEND.C - UTC Send
// 
//
//   DESCRIPTION
//
//   Functions for sending UTC to and retrieving UTC from the
//   receiver.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\UTC_SEND.C_v  $
//   
//      Rev 1.15   09 Nov 1998 10:47:40   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 09:42:52   COLEJ
//   Multiple Changes...
//   
//      Rev 1.2   Feb 12 1997 16:04:54   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:00:42   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:22   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <string.h>
#include <share.h>

#include "LABMON.H"
#include "INITFUNC.H"
#include "MESS_IO.H"
#include "MONMISC.H"

extern char          buff[80];
extern unsigned char msgbuff[MAX_MSG_BUFFER];           
extern unsigned char tx_buff[MAX_TX_BUFFER];
extern unsigned char filebuff[4000];
extern short         cmdline; 
extern short         MainTextColor;  
extern short         MainDataColor;  
extern unsigned long Cnt1242;

extern tDATATYPE DataType;

static FILE                 *Utc_FilePtr = NULL;

short get_utc_file(void)
{
   short   option; 
   char  FileName[35];
   short   valid;                                            

   clear_message_line();  
   _outtext("SELECT FILE -> ");
   _settextcolor(MainTextColor);
   _outtext( "U" );
   _settextcolor(MainDataColor);
   _outtext( "TC.GPS  " );
   _settextcolor(MainTextColor);

   _outtext( "O" );
   _settextcolor(MainDataColor);
   _outtext( "THER" );

   option = getch();  
   clear_message_line();
   strcpy(FileName, "UTC.GPS");
   
   if(option != 'U' && option != 'u'){
      clear_message_line();
      ask_str("UTC FILE NAME -> ", FileName, &valid);
      //_outtext("ALMANAC FILE NAME -> ");
      //getns(FileName, 35);
      clear_message_line(); 
      if(!valid) return(1);     
   }
   clear_message_line(); 
      
   if((Utc_FilePtr = _fsopen(FileName, "rb", SH_DENYWR)) == NULL){
      clear_message_line();
      _outtext("COULDN'T OPEN UTC FILE!\7");
      return(1);
   }
   else{
      return(0);
   }
}
 
short send_utc(void)
{
   short i; 
   
   if(Utc_FilePtr == NULL){
      return(1);
   }

   if(DataType == NC_BINARY){
      return(1);
   } //end if NC_BINARY
   
   if(DataType == Z_BINARY){
     // read another almanac record
     for(i=0;i<38;i++){
       tx_buff[i] = (unsigned char)fgetc(Utc_FilePtr);
     }
 
     if(*(short*)(tx_buff+2) == 1242){
        cputs("\a");
        sprintf(buff, "UTC SENT");
        clear_message_line();
        _outtext(buff);
        Cnt1242++;
        send_msg(tx_buff);
     }
     return(0);
   } //end if Z_BINARY 
     
}


short store_utc(short file_len)
{
   short i;

   if((Utc_FilePtr = _fsopen("UTC.GPS", "wb", SH_DENYWR)) == NULL) {
      clear_message_line();
      _outtext("COULDN'T OPEN UTC DATA FILE!");
      return(1);
   }
   else{
      clear_message_line();
      _outtext("UTC DATA FILE OPENED");

      for(i=0;i<file_len; i++){
         fputc(filebuff[i], Utc_FilePtr);
      }
      fclose(Utc_FilePtr);
      clear_message_line();
      _outtext("UTC DATA FILE CLOSED     "); 
      return(0);
   }
}
